/*
 * Decompiled with CFR 0.152.
 */
package fr.kinderrkill.launcher.utils;

import fr.kinderrkill.launcher.utils.Config;
import fr.kinderrkill.launcher.utils.OSHelper;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;

public class Utils {
    public static String BASE_URL = Config.get("BASE_URL");
    public static String DOWNLOAD_URL = Config.get("DOWNLOAD_URL");
    public static String CLIENT_TITLE = Config.get("CLIENT_TITLE");
    public static String CLIENT_FILE_NAME = Config.get("CLIENT_FILE_NAME");
    public static String CLIENT_VERSION_NAME = Config.get("CLIENT_VERSION_NAME");
    public static String RESOURCE_PACK_NAME = Config.get("RESOURCE_PACK_NAME");
    public static String MINECRAFT_PROFIL_ICON = Config.get("MINECRAFT_PROFIL_ICON");
    public static String gameVersionNumber = null;

    public static String getOnlineGameVersion() {
        String onlineGameVersion = null;
        try {
            InputStream stream = Utils.getResourceFromUrl(DOWNLOAD_URL + CLIENT_VERSION_NAME + ".txt");
            InputStreamReader reader = new InputStreamReader(stream);
            BufferedReader buffReader = new BufferedReader(reader);
            onlineGameVersion = buffReader.readLine();
            buffReader.close();
            reader.close();
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return onlineGameVersion;
    }

    public static String getLocalGameVersion() {
        File localVersion;
        File clientDestination;
        String minecraftDirectory = OSHelper.getOS().getMinecraftDirectory();
        File versionDirectory = new File(minecraftDirectory, "versions");
        if (!versionDirectory.exists()) {
            versionDirectory.mkdir();
        }
        if (!(clientDestination = new File(versionDirectory, CLIENT_FILE_NAME)).exists()) {
            clientDestination.mkdir();
        }
        if ((localVersion = new File(clientDestination, CLIENT_VERSION_NAME + ".txt")).exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(localVersion));
                gameVersionNumber = br.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            gameVersionNumber = "0";
        }
        return gameVersionNumber;
    }

    public static BufferedImage getResource(String resource) {
        try {
            return ImageIO.read(Utils.class.getResourceAsStream("/assets/" + resource));
        }
        catch (IOException | IllegalArgumentException e) {
            throw new IllegalArgumentException("Can't load the given resource (" + resource + ") : " + e);
        }
    }

    public static InputStream getResourceFromUrl(String url) throws IOException {
        URLConnection connection = new URL(url).openConnection();
        connection.setRequestProperty("User-Agent", "Mozilla/5.0");
        connection.setRequestProperty("Accept_Language", "en-US,q=0.5");
        connection.setDoOutput(true);
        return connection.getInputStream();
    }

    public static String readFile(File fileIn) throws IOException {
        String currLine;
        FileReader fileReader = new FileReader(fileIn);
        BufferedReader buffReader = new BufferedReader(fileReader);
        StringBuilder sb = new StringBuilder();
        while ((currLine = buffReader.readLine()) != null && !currLine.startsWith("#")) {
            sb.append(currLine);
        }
        buffReader.close();
        fileReader.close();
        return sb.toString();
    }

    public static void writeFile(String text, File file) throws IOException {
        if (file.exists()) {
            file.delete();
        }
        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(file, true)));
        writer.println(text);
        writer.close();
    }
}

