/*
 * Decompiled with CFR 0.152.
 */
package fr.kinderrkill.launcher.utils;

import fr.kinderrkill.launcher.LauncherPanel;
import fr.kinderrkill.launcher.utils.OSHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.swing.JOptionPane;

public class MinecraftLauncherFinder {
    private static final String[] exeMd5 = new String[]{"350df398c57c56ed744306de95a4e451", "3389f0c8717e7438bfb0b03498756f27", "3c166bae84553d4cb27af8abdc61712d", "7C710AE7EF7A774B30E04C3867F9B96E"};
    private static final String[] jarMd5 = new String[]{"85273e24404cc6865805f951487b8a1e"};
    private static final int BUFFER_SIZE = 0x300000;
    private static final byte[] buffer = new byte[0x300000];
    public static boolean searching = true;
    private static String launcherPath = null;
    private static MessageDigest messageDigest = null;

    public static File getMinecraftLauncherPath() {
        if (launcherPath == null) {
            return null;
        }
        return new File(launcherPath);
    }

    public static void startSearch(LauncherPanel launcherMainPanel) {
        String path = MinecraftLauncherFinder.searchMinecraftLauncher();
        searching = false;
        if (path != null) {
            launcherPath = path;
        }
        if (launcherMainPanel != null) {
            launcherMainPanel.updateMinecraftLauncher();
        }
    }

    private static String searchMinecraftLauncher() {
        String found;
        String found2;
        String found3;
        String UserDirectoryPath;
        String found4;
        String programFile;
        if (OSHelper.getOS() == OSHelper.MAC) {
            String found5;
            String applicationPath = "/Applications";
            File applicationFile = new File(applicationPath);
            File minecraftAppFile = new File(applicationFile, "/Minecraft.app");
            File contentFile = new File(minecraftAppFile, "/Contents");
            File resourcesAppFile = new File(contentFile, "/Resources");
            File javaFile = new File(resourcesAppFile, "/Java");
            File bootstrapFile = new File(javaFile, "Bootstrap.jar");
            if (bootstrapFile.exists()) {
                return bootstrapFile.toString();
            }
            if (applicationPath != null && (found5 = MinecraftLauncherFinder.SearchInDirectory(applicationPath)) != null) {
                return found5;
            }
        }
        if (OSHelper.getOS() == OSHelper.WINDOWS && (programFile = System.getenv("ProgramFiles(X86)")) != null) {
            File launcher;
            File pFile = new File(programFile);
            File mpFile = new File(pFile, "Minecraft Launcher");
            if (!mpFile.exists()) {
                mpFile = new File(pFile, "Minecraft");
            }
            if ((launcher = new File(mpFile, "MinecraftLauncher.exe")).exists()) {
                return launcher.toString();
            }
            found4 = MinecraftLauncherFinder.SearchInDirectory(mpFile.getAbsolutePath());
            if (found4 != null) {
                return found4;
            }
        }
        if ((UserDirectoryPath = System.getProperty("user.dir")) != null && (found3 = MinecraftLauncherFinder.SearchInDirectory(UserDirectoryPath)) != null) {
            return found3;
        }
        String homeDirectoryPath = System.getProperty("user.home");
        if (homeDirectoryPath != null && (found2 = MinecraftLauncherFinder.SearchInDirectory(homeDirectoryPath)) != null) {
            return found2;
        }
        String desktopDirectoryPath = System.getProperty("user.home") + System.getProperty("file.separator") + "Desktop";
        if (desktopDirectoryPath != null && (found = MinecraftLauncherFinder.SearchInDirectory(desktopDirectoryPath)) != null) {
            return found;
        }
        String downloadDirectoryPath = System.getProperty("user.home") + System.getProperty("file.separator") + "Downloads";
        if (downloadDirectoryPath != null && (found4 = MinecraftLauncherFinder.SearchInDirectory(downloadDirectoryPath)) != null) {
            return found4;
        }
        return null;
    }

    public static void launchMinecraftLauncher() {
        Runtime runtime = Runtime.getRuntime();
        try {
            File pathToMinecraftLauncher = LauncherPanel.getInstance().getMinecraftLauncher();
            if (pathToMinecraftLauncher != null) {
                File launcher = pathToMinecraftLauncher;
                if (pathToMinecraftLauncher.getName().endsWith(".app")) {
                    launcher = new File(pathToMinecraftLauncher, "Contents" + File.separator + "Resources" + File.separator + "Java" + File.separator + "Bootstrap.jar");
                }
                if (launcher.canExecute() && !launcher.toString().endsWith(".jar")) {
                    runtime.exec(new String[]{launcher.toString(), "--workDir", OSHelper.getOS().getMinecraftDirectory()});
                } else {
                    runtime.exec(new String[]{"java", "-jar", launcher.toString(), "--workDir", OSHelper.getOS().getMinecraftDirectory()});
                }
                System.exit(0);
            } else {
                JOptionPane.showMessageDialog(null, "L'installeur peut lancer automatiquement le launcher Minecraft si celui-ci est d\u00e9fini\n\nExemple pour " + (Object)((Object)OSHelper.getOS()) + " :    " + (OSHelper.getOS().equals((Object)OSHelper.WINDOWS) ? "Minecraft Launcher.exe" : (OSHelper.getOS().equals((Object)OSHelper.LINUX) ? "Minecraft Launcher.jar" : "Minecraft Launcher.app")) + "\n", "Launcher Minecraft non d\u00e9tect\u00e9 !", 1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Erreur lors du lancement du launcher Minecraft.", "Erreur", 0);
        }
    }

    private static boolean checkMd5(String currentFileMd5) {
        for (String s : jarMd5) {
            if (!s.equals(currentFileMd5)) continue;
            return true;
        }
        if (OSHelper.getOS() == OSHelper.WINDOWS) {
            for (String s : exeMd5) {
                if (!s.equals(currentFileMd5)) continue;
                return true;
            }
        }
        return false;
    }

    private static String computeMd5(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            int pos = 0;
            int readed = fis.read(buffer, 0, 0x300000);
            while (readed > 0) {
                readed = fis.read(buffer, pos += readed, 0x300000 - pos);
            }
            fis.close();
            messageDigest.reset();
            messageDigest.update(buffer, 0, pos);
            String currentFileMd5 = new BigInteger(1, messageDigest.digest()).toString(16);
            while (currentFileMd5.length() < 32) {
                currentFileMd5 = "0" + currentFileMd5;
            }
            return currentFileMd5;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static String SearchInDirectory(String directoryPath) {
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e1) {
            return null;
        }
        File directory = new File(directoryPath);
        if (directory.isDirectory()) {
            for (String f : directory.list()) {
                String currentFileMd5;
                long size;
                String currentFileMd52;
                File bootstrapFile;
                File currentFile = new File(directory, f);
                if (!(currentFile.isDirectory() ? currentFile.toString().endsWith(".app") && (bootstrapFile = new File(currentFile, "Contents" + File.separator + "Resources" + File.separator + "Java" + File.separator + "Bootstrap.jar")).exists() && MinecraftLauncherFinder.checkMd5(currentFileMd52 = MinecraftLauncherFinder.computeMd5(bootstrapFile)) : currentFile.canRead() && (size = currentFile.length()) <= 0x300000L && size >= 16L && MinecraftLauncherFinder.checkMd5(currentFileMd5 = MinecraftLauncherFinder.computeMd5(currentFile)))) continue;
                return currentFile.toString();
            }
        }
        return null;
    }
}

