/*
 * Decompiled with CFR 0.152.
 */
package fr.kinderrkill.launcher.utils;

import fr.kinderrkill.launcher.LauncherPanel;
import fr.kinderrkill.launcher.utils.MinecraftLauncherFinder;
import fr.kinderrkill.launcher.utils.OSHelper;
import fr.kinderrkill.launcher.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JOptionPane;
import org.json.JSONObject;

public class Installer {
    private final LauncherPanel panel;
    private final List<File> filesToDownload;
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy'T'HH:mm:ss.SSS'Z'", Locale.FRANCE);
    private int downloadTotalSize;

    public Installer(LauncherPanel panel) {
        this.panel = panel;
        this.filesToDownload = new ArrayList<File>();
    }

    public static void launchMinecraft() {
        Installer.setUpLauncherProfile();
        MinecraftLauncherFinder.launchMinecraftLauncher();
    }

    private static void setUpLauncherProfile() {
        String minecraftDirectory = OSHelper.getOS().getMinecraftDirectory();
        File profilesFile = new File(minecraftDirectory, "launcher_profiles.json");
        if (!profilesFile.exists()) {
            return;
        }
        try {
            FileInputStream fis = new FileInputStream(profilesFile);
            byte[] data = new byte[(int)profilesFile.length()];
            fis.read(data);
            fis.close();
            String json = new String(data, StandardCharsets.UTF_8);
            JSONObject profilesJson = new JSONObject(json);
            JSONObject profiles = (JSONObject)profilesJson.get("profiles");
            JSONObject newProfile = new JSONObject();
            newProfile.put("name", Utils.CLIENT_FILE_NAME + " V." + Utils.getOnlineGameVersion());
            newProfile.put("icon", Utils.MINECRAFT_PROFIL_ICON);
            newProfile.put("lastVersionId", Utils.CLIENT_FILE_NAME);
            newProfile.put("useHopperCrashService", false);
            profiles.put(Utils.CLIENT_FILE_NAME, newProfile);
            fis.close();
            FileWriter fw = new FileWriter(profilesFile);
            fw.write(profilesJson.toString(4));
            fw.close();
        }
        catch (IOException | ClassCastException e) {
            e.printStackTrace();
        }
    }

    public void start() {
        this.initFilesToDownload();
        this.startDownloadThread();
    }

    private void initFilesToDownload() {
        File clientDestination;
        String minecraftDirectory = OSHelper.getOS().getMinecraftDirectory();
        File versionDirectory = new File(minecraftDirectory, "versions");
        if (!versionDirectory.exists()) {
            versionDirectory.mkdir();
        }
        if (!(clientDestination = new File(versionDirectory, Utils.CLIENT_FILE_NAME)).exists()) {
            clientDestination.mkdir();
        }
        this.filesToDownload.add(new File(clientDestination, Utils.CLIENT_FILE_NAME + ".json"));
        this.filesToDownload.add(new File(clientDestination, Utils.CLIENT_FILE_NAME + ".jar"));
        if (!Utils.RESOURCE_PACK_NAME.equalsIgnoreCase("null")) {
            File resourcePackDestination = new File(minecraftDirectory, "resourcepacks");
            if (!resourcePackDestination.exists()) {
                resourcePackDestination.mkdir();
            }
            this.filesToDownload.add(new File(resourcePackDestination, Utils.RESOURCE_PACK_NAME + ".zip"));
        }
    }

    private void precalculateDownloadSize() {
        int totalSize = 1;
        for (File file : this.filesToDownload) {
            try {
                URL urlDowndloadFile = new URL(Utils.DOWNLOAD_URL + file.getName());
                URLConnection httpHeadRequest = urlDowndloadFile.openConnection();
                httpHeadRequest.setDefaultUseCaches(false);
                if (httpHeadRequest instanceof HttpURLConnection) {
                    ((HttpURLConnection)httpHeadRequest).setRequestMethod("HEAD");
                }
                totalSize += httpHeadRequest.getContentLength();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.downloadTotalSize = totalSize;
    }

    private boolean downloadFilesToDownload() {
        int totalDownload = 0;
        int bufferSize = 65536;
        boolean fileDownloaded = false;
        double bytesTotal = this.downloadTotalSize;
        double kilobytesTotal = bytesTotal / 1024.0;
        double megabytesTotal = kilobytesTotal / 1024.0;
        String totalMOToDisplay = String.format("%.2f", megabytesTotal);
        byte[] buffer = new byte[bufferSize];
        for (File file : this.filesToDownload) {
            try {
                URL urlDowndloadFile = new URL(Utils.DOWNLOAD_URL + file.getName());
                InputStream is = urlDowndloadFile.openStream();
                FileOutputStream destination = new FileOutputStream(file);
                int readed = is.read(buffer, 0, bufferSize);
                while (readed >= 0) {
                    destination.write(buffer, 0, readed);
                    double bytesActual = totalDownload += readed;
                    double kilobytesActual = bytesActual / 1024.0;
                    double megabytesActual = kilobytesActual / 1024.0;
                    String actualMOToDisplay = String.format("%.2f", megabytesActual);
                    this.panel.getProgressBar().setValue(totalDownload * 100 / this.downloadTotalSize);
                    this.panel.getProgressLabel().setText("T\u00e9l\u00e9chargement des " + this.filesToDownload.size() + " fichiers : " + actualMOToDisplay + "mo / " + totalMOToDisplay + "mo (" + totalDownload * 100 / this.downloadTotalSize + " %)");
                    readed = is.read(buffer, 0, bufferSize);
                }
                destination.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        this.panel.getProgressBar().setValue(100);
        this.panel.getProgressLabel().setText("T\u00e9l\u00e9chargement des fichiers termin\u00e9s !");
        return true;
    }

    private void startDownloadThread() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                if (Installer.this.needUpdate()) {
                    Installer.this.precalculateDownloadSize();
                    if (!Installer.this.downloadFilesToDownload()) {
                        JOptionPane.showMessageDialog(null, "Erreur lors du t\u00e9l\u00e9chargement du client " + Utils.CLIENT_TITLE, "Erreur " + Utils.CLIENT_TITLE, 0);
                    } else {
                        Installer.this.saveGameVersion();
                    }
                }
                Installer.this.panel.getStartButton().setEnabled(true);
                Installer.launchMinecraft();
            }
        });
        t.start();
    }

    private boolean needUpdate() {
        int onlineGameVersion;
        int localGameVersion = Integer.parseInt(Utils.getLocalGameVersion());
        return localGameVersion < (onlineGameVersion = Integer.parseInt(Utils.getOnlineGameVersion()));
    }

    private void saveGameVersion() {
        try {
            File clientDestination;
            String minecraftDirectory = OSHelper.getOS().getMinecraftDirectory();
            File versionDirectory = new File(minecraftDirectory, "versions");
            if (!versionDirectory.exists()) {
                versionDirectory.mkdir();
            }
            if (!(clientDestination = new File(versionDirectory, Utils.CLIENT_FILE_NAME)).exists()) {
                clientDestination.mkdir();
            }
            PrintWriter writer = new PrintWriter(clientDestination + "/" + Utils.CLIENT_VERSION_NAME + ".txt", "UTF-8");
            writer.println(Utils.getOnlineGameVersion());
            writer.close();
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

