/*
 * Decompiled with CFR 0.152.
 */
package fr.kinderrkill.launcher.utils;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Config {
    public static int width;
    public static int height;
    private static Properties properties;

    public static void init() {
        width = Config.getInt("WINDOW_WIDTH");
        height = Config.getInt("WINDOW_HEIGHT");
    }

    public static String get(String key) {
        if (properties == null) {
            properties = new Properties();
            try {
                InputStream is = Config.class.getResourceAsStream("/Launcher.properties");
                properties.load(is);
                is.close();
            }
            catch (IOException | NullPointerException e) {
                e.printStackTrace();
            }
        } else {
            String var;
            String varValue;
            String result = properties.getProperty(key);
            if (result.startsWith("%") && result.endsWith("%") && (varValue = Config.get(var = result.replaceAll("%", ""))) != null) {
                return varValue;
            }
        }
        return properties != null ? properties.getProperty(key) : null;
    }

    public static int getInt(String key) {
        return Integer.parseInt(Config.get(key));
    }

    public static Color getColor(String key) {
        return Color.decode(Config.get(key));
    }

    private static int[] getRGB(String key) {
        int[] ret = new int[3];
        for (int i = 0; i < 3; ++i) {
            ret[i] = Config.hexToInt(Config.get(key).charAt(i * 2), Config.get(key).charAt(i * 2 + 1));
        }
        return ret;
    }

    private static int hexToInt(char a, char b) {
        int x = a < 'A' ? a - 48 : a - 55;
        int y = b < 'A' ? b - 48 : b - 55;
        return x * 16 + y;
    }

    public static int getRelativeInt(String key) {
        if (Config.get(key).endsWith("%w%")) {
            return (int)((float)width / 100.0f * (float)Integer.parseInt(Config.get(key).replaceAll("%w%", "")));
        }
        if (Config.get(key).endsWith("%h%")) {
            return (int)((float)height / 100.0f * (float)Integer.parseInt(Config.get(key).replaceAll("%h%", "")));
        }
        return Config.getInt(key);
    }

    public static Alignment getAlignment(String key) {
        String value = Config.get(key);
        return Alignment.valueOf(value);
    }

    static {
        properties = null;
    }

    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

