/*
 * Decompiled with CFR 0.152.
 */
package fr.kinderrkill.launcher;

import fr.kinderrkill.launcher.utils.Config;
import fr.kinderrkill.launcher.utils.Installer;
import fr.kinderrkill.launcher.utils.MinecraftLauncherFilter;
import fr.kinderrkill.launcher.utils.MinecraftLauncherFinder;
import fr.kinderrkill.launcher.utils.OSHelper;
import fr.kinderrkill.launcher.utils.Utils;
import fr.theshark34.swinger.Swinger;
import fr.theshark34.swinger.colored.SColoredBar;
import fr.theshark34.swinger.textured.STexturedButton;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LauncherPanel
extends JPanel {
    private static LauncherPanel instance;
    private final Installer installer;
    private STexturedButton startButton;
    private SColoredBar progressBar;
    private JLabel progressLabel;
    private File minecraftLauncher;
    private JLabel minecraftLauncherPath;

    public LauncherPanel() {
        instance = this;
        this.installer = new Installer(this);
        MinecraftLauncherFinder.startSearch(this);
        this.setLayout(null);
        this.setBackground(Swinger.TRANSPARENT);
        this.setupComponent();
        this.loadLauncherData();
    }

    public static LauncherPanel getInstance() {
        return instance;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Swinger.drawFullsizedImage(g, this, Utils.getResource(Config.get("BACKGROUND_TEXTURE")));
        int logoWidth = Config.getRelativeInt("MAIN_LOGO_WIDTH");
        int logoHeight = Config.getRelativeInt("MAIN_LOGO_HEIGHT");
        int logoPosX = Config.getRelativeInt("MAIN_LOGO_POS_X");
        int logoPosY = Config.getRelativeInt("MAIN_LOGO_POS_Y");
        g.drawImage(Utils.getResource(Config.get("MAIN_LOGO_TEXTURE")), logoPosX - logoWidth / 2, logoPosY, logoWidth, logoHeight, this);
    }

    private void setupComponent() {
        this.startButton = new STexturedButton(Utils.getResource(Config.get("PLAY_BUTTON_0_TEXTURE")), Utils.getResource(Config.get("PLAY_BUTTON_1_TEXTURE")), Utils.getResource(Config.get("PLAY_BUTTON_2_TEXTURE")));
        Config.Alignment startButtonAlign = Config.getAlignment("PLAY_BUTTON_ALIGN");
        switch (startButtonAlign) {
            case LEFT: {
                this.startButton.setBounds(Config.getRelativeInt("PLAY_BUTTON_POS_X"), Config.getRelativeInt("PLAY_BUTTON_POS_Y"), Config.getRelativeInt("PLAY_BUTTON_WIDTH"), Config.getRelativeInt("PLAY_BUTTON_HEIGHT"));
                break;
            }
            case CENTER: {
                this.startButton.setBounds(Config.getRelativeInt("PLAY_BUTTON_POS_X") - Config.getRelativeInt("PLAY_BUTTON_WIDTH") / 2, Config.getRelativeInt("PLAY_BUTTON_POS_Y"), Config.getRelativeInt("PLAY_BUTTON_WIDTH"), Config.getRelativeInt("PLAY_BUTTON_HEIGHT"));
                break;
            }
            case RIGHT: {
                this.startButton.setBounds(Config.getRelativeInt("PLAY_BUTTON_POS_X") - Config.getRelativeInt("PLAY_BUTTON_WIDTH"), Config.getRelativeInt("PLAY_BUTTON_POS_Y"), Config.getRelativeInt("PLAY_BUTTON_WIDTH"), Config.getRelativeInt("PLAY_BUTTON_HEIGHT"));
                break;
            }
            default: {
                this.startButton.setBounds(Config.getRelativeInt("PLAY_BUTTON_POS_X"), Config.getRelativeInt("PLAY_BUTTON_POS_Y"), Config.getRelativeInt("PLAY_BUTTON_WIDTH"), Config.getRelativeInt("PLAY_BUTTON_HEIGHT"));
            }
        }
        this.startButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LauncherPanel.this.installer.start();
                LauncherPanel.this.startButton.setEnabled(false);
            }
        });
        this.add(this.startButton);
        int barPosX = Config.getRelativeInt("BAR_POS_X");
        int barPosY = Config.getRelativeInt("BAR_POS_Y");
        int barWidth = Config.getRelativeInt("BAR_WIDTH");
        int barHeight = Config.getRelativeInt("BAR_HEIGHT");
        Config.Alignment barAlign = Config.getAlignment("BAR_ALIGN");
        this.progressBar = new SColoredBar(Config.getColor("BAR_COLOR_PRIMARY"), Config.getColor("BAR_COLOR_SECONDARY"));
        switch (barAlign) {
            case LEFT: {
                this.progressBar.setBounds(barPosX, barPosY, barWidth, barHeight);
                break;
            }
            case CENTER: {
                this.progressBar.setBounds(barPosX - barWidth / 2, barPosY, barWidth, barHeight);
                break;
            }
            case RIGHT: {
                this.progressBar.setBounds(barPosX - barWidth, barPosY, barWidth, barHeight);
                break;
            }
            default: {
                this.progressBar.setBounds(barPosX, barPosY, barWidth, barHeight);
            }
        }
        this.progressBar.setMaximum(100);
        this.progressLabel = new JLabel(Utils.CLIENT_TITLE + " - Version " + Utils.getOnlineGameVersion(), 0);
        switch (barAlign) {
            case LEFT: {
                this.progressLabel.setBounds(barPosX, barPosY - 2, barWidth, 20);
                break;
            }
            case CENTER: {
                this.progressLabel.setBounds(barPosX - barWidth / 2, barPosY - 2, barWidth, 20);
                break;
            }
            case RIGHT: {
                this.progressLabel.setBounds(barPosX - barWidth, barPosY - 2, barWidth, 20);
                break;
            }
            default: {
                this.progressLabel.setBounds(barPosX, barPosY - 2, barWidth, 20);
            }
        }
        this.progressLabel.setFont(new Font(this.progressLabel.getFont().getName(), 1, 15));
        this.progressLabel.setForeground(Config.getColor("BAR_COLOR_TEXT"));
        this.add(this.progressLabel);
        this.add(this.progressBar);
        int pathY = Config.getRelativeInt("MINECRAFT_PATH_POS_Y");
        this.minecraftLauncherPath = new JLabel("", 0);
        this.minecraftLauncherPath.setBounds(0, pathY, Config.width, 40);
        this.minecraftLauncherPath.setFont(new Font(this.minecraftLauncherPath.getFont().getName(), 1, 15));
        this.minecraftLauncherPath.setForeground(Color.WHITE);
        this.minecraftLauncherPath.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                LauncherPanel.this.minecraftLauncherPath.setForeground(Color.YELLOW);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LauncherPanel.this.minecraftLauncherPath.setForeground(Color.WHITE);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                LauncherPanel.this.askMinecraftLauncher();
            }
        });
        this.add(this.minecraftLauncherPath);
        this.displayMinecraftLauncherPath();
    }

    private void askMinecraftLauncher() {
        if (!(this.minecraftLauncher != null && this.minecraftLauncher.exists() || MinecraftLauncherFinder.searching)) {
            this.minecraftLauncher = MinecraftLauncherFinder.getMinecraftLauncherPath();
            if (this.minecraftLauncher != null && this.minecraftLauncher.exists()) {
                this.displayMinecraftLauncherPath();
                return;
            }
        }
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("D\u00e9finir l'emplacement du Launcher Minecraft");
        fc.setFileFilter(new MinecraftLauncherFilter());
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            this.minecraftLauncher = fc.getSelectedFile();
        }
        this.displayMinecraftLauncherPath();
    }

    public void updateMinecraftLauncher() {
        if (!(this.minecraftLauncher != null && this.minecraftLauncher.exists() || MinecraftLauncherFinder.searching)) {
            this.minecraftLauncher = MinecraftLauncherFinder.getMinecraftLauncherPath();
        }
    }

    public void displayMinecraftLauncherPath() {
        if (MinecraftLauncherFinder.searching) {
            this.minecraftLauncherPath.setText("<html><center><u>Launcher Minecraft :</u><br><FONT SIZE=\"3\">> Recherche en cours...</FONT></center></html>");
        } else if (this.minecraftLauncher == null) {
            this.minecraftLauncherPath.setText("<html><center><u>Launcher Minecraft (Cliquer pour d\u00e9finir) :</u><br><FONT SIZE=\"3\">> Introuvable...</FONT></center></html>");
        } else {
            this.minecraftLauncherPath.setText("<html><center><u>Launcher Minecraft :</u><br><FONT SIZE=\"3\">" + this.minecraftLauncher + "</FONT></center></html>");
            this.saveLauncherData();
        }
    }

    public File getMinecraftLauncher() {
        if (this.minecraftLauncher == null) {
            this.askMinecraftLauncher();
            if (this.minecraftLauncher == null) {
                return null;
            }
        }
        if (this.minecraftLauncher.exists()) {
            return this.minecraftLauncher;
        }
        this.askMinecraftLauncher();
        return null;
    }

    public void saveLauncherData() {
        File clientDirectory = new File(OSHelper.getOS().getMinecraftDirectory());
        if (!clientDirectory.exists()) {
            clientDirectory.mkdir();
        }
        try {
            File launcherProperties = new File(clientDirectory, Utils.CLIENT_FILE_NAME.toLowerCase() + "-installer.properties");
            Properties properties = new Properties();
            if (this.minecraftLauncher != null && this.minecraftLauncher.exists()) {
                properties.setProperty("minecraftLauncher", this.minecraftLauncher.toString());
            }
            FileOutputStream fos = new FileOutputStream(launcherProperties);
            properties.store(fos, null);
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadLauncherData() {
        File clientDirectory = new File(OSHelper.getOS().getMinecraftDirectory());
        if (!clientDirectory.exists()) {
            return;
        }
        try {
            File launcherProperties = new File(clientDirectory, Utils.CLIENT_FILE_NAME.toLowerCase() + "-installer.properties");
            if (!launcherProperties.exists()) {
                return;
            }
            FileInputStream fis = new FileInputStream(launcherProperties);
            Properties properties = new Properties();
            properties.load(fis);
            this.minecraftLauncher = null;
            String minecraftLauncherPath = properties.getProperty("minecraftLauncher");
            if (this.minecraftLauncher != null) {
                this.minecraftLauncher = new File(minecraftLauncherPath);
            }
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public SColoredBar getProgressBar() {
        return this.progressBar;
    }

    public STexturedButton getStartButton() {
        return this.startButton;
    }

    public JLabel getProgressLabel() {
        return this.progressLabel;
    }
}

